<?php
date_default_timezone_set("Asia/Jakarta");
$servername   = "localhost";
$username     = "root";
$password     = "";
$dbname       = "app_kos";
$conn         = mysqli_connect($servername, $username, $password, $dbname) or die("Connection failed: " . mysqli_connect_error());
$mysqli       = new mysqli($servername, $username, $password, $dbname);

// Rubah lokasi url sesuai dengan letak software berada
$base_url          = "http://localhost/appkoss/app_kos";

function pengaman($data)
{
    global $conn;
    $filter = mysqli_real_escape_string($conn, $data);
    return $filter;
}

function nourut($table, $kode)
{
    global $conn;
    $sql_nourut   = mysqli_query($conn, "SELECT max($kode) as maxKode
                                                            FROM $table");
    $row     = mysqli_fetch_array($sql_nourut);
    return $row['maxKode'] + 1;
}

function auto_kode($table, $coloumn, $inisial, $panjangkarakter)
{
    global $conn;

    // Mendapatkan kode terbesar dari database
    $query = mysqli_query($conn, "SELECT MAX($coloumn) AS kodeTerbesar FROM $table WHERE $coloumn LIKE '%$inisial%'");
    $data = mysqli_fetch_assoc($query);
    $kodeTerbesar = $data['kodeTerbesar'];

    // Memeriksa apakah kode terbesar sudah ada atau belum
    if ($kodeTerbesar === null) {
        $urutan = 1;
    } else {
        // Mendapatkan urutan dari kode terbesar
        preg_match('/(\d+)$/', $kodeTerbesar, $matches);
        $urutan = $matches[1] + 1;
    }

    // Membentuk format kode baru sesuai dengan kebutuhan
    $nomorUrut = str_pad($urutan, $panjangkarakter - strlen($inisial), '0', STR_PAD_LEFT);
    $kodeBaru = $inisial . $nomorUrut;

    return $kodeBaru;
}


function unformatRibuan($rupiah) {
    // Hapus semua koma dari string
    $number_string = str_replace(',', '', $rupiah);
    // Konversi string yang telah dimodifikasi menjadi bilangan desimal
    $number_value = floatval($number_string);
    // Bulatkan nilai desimal ke dua angka di belakang koma
    $rounded_value = round($number_value, 2);
    return $rounded_value;
}

function terbilang_rupiah($angka) {
    $bilangan = array(
        '',
        'satu',
        'dua',
        'tiga',
        'empat',
        'lima',
        'enam',
        'tujuh',
        'delapan',
        'sembilan',
        'sepuluh',
        'sebelas'
    );

    if ($angka < 12) {
        return $bilangan[$angka];
    } elseif ($angka < 20) {
        return terbilang_rupiah($angka - 10) . ' belas';
    } elseif ($angka < 100) {
        return terbilang_rupiah($angka / 10) . ' puluh ' . terbilang_rupiah($angka % 10);
    } elseif ($angka < 200) {
        return ' seratus ' . terbilang_rupiah($angka - 100);
    } elseif ($angka < 1000) {
        return terbilang_rupiah($angka / 100) . ' ratus ' . terbilang_rupiah($angka % 100);
    } elseif ($angka < 2000) {
        return ' seribu ' . terbilang_rupiah($angka - 1000);
    } elseif ($angka < 1000000) {
        return terbilang_rupiah($angka / 1000) . ' ribu ' . terbilang_rupiah($angka % 1000);
    } elseif ($angka < 1000000000) {
        return terbilang_rupiah($angka / 1000000) . ' juta ' . terbilang_rupiah($angka % 1000000);
    } elseif ($angka < 1000000000000) {
        return terbilang_rupiah($angka / 1000000000) . ' milyar ' . terbilang_rupiah($angka % 1000000000);
    } elseif ($angka < 1000000000000000) {
        return terbilang_rupiah($angka / 1000000000000) . ' trilyun ' . terbilang_rupiah($angka % 1000000000000);
    } elseif ($angka < 1000000000000000000) {
        return terbilang_rupiah($angka / 1000000000000000) . ' kuadriliun ' . terbilang_rupiah($angka % 1000000000000000);
    } else {
        return 'undefined';
    }
}

function terbilang_rupiah_format($angka) {
    $hasil_terbilang = terbilang_rupiah($angka);
    return ucwords($hasil_terbilang) . ' Rupiah';
}

function formatIndonesianDate($date) {
    $months = [
        'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    ];
    
    $dateTime = new DateTime($date);
    $day = $dateTime->format('d');
    $month = $months[(int)$dateTime->format('m') - 1];
    $year = $dateTime->format('Y');
    
    return $day . ' ' . $month . ' ' . $year;
}

function addMonths($date, $months) {
    $dateTime = new DateTime($date);
    $originalDay = $dateTime->format('d');

    // Adding months
    $dateTime->modify("+$months months");

    // Adjusting to last day of previous month if needed
    if ($dateTime->format('d') < $originalDay) {
        $dateTime->modify('last day of previous month');
    }

    return $dateTime->format('Y-m-d');
}

function addDays($date, $days) {
    $dateTime = new DateTime($date);
    $dateTime->modify("+$days days");
    return $dateTime->format('Y-m-d');
}


function generateWhatsAppLink($phoneNumber, $message) {
    // Encode the message to be URL safe
    $encodedMessage = urlencode($message);
    
    // Create the WhatsApp URL
    $whatsAppUrl = "https://wa.me/" . $phoneNumber . "?text=" . $encodedMessage;
    
    return $whatsAppUrl;
}

function convertToInternationalFormat($phoneNumber) {
    // Remove any non-numeric characters (optional, based on requirement)
    $phoneNumber = preg_replace('/\D/', '', $phoneNumber);

    // Check if the number starts with '0' and replace it with '62'
    if (substr($phoneNumber, 0, 1) === '0') {
        $phoneNumber = '62' . substr($phoneNumber, 1);
    }

    return $phoneNumber;
}

$create_at    = date('Y-m-d');
$years        = date('Y');

$sqlPerusahaan              = mysqli_query($conn, "SELECT * FROM setup_pengaturan");
$rowPerusahaan              = mysqli_fetch_array($sqlPerusahaan);
$nama_perusahaan            = $rowPerusahaan['nama_perusahaan'];
$nama_aplikasi              = $rowPerusahaan['nama_aplikasi'];
$no_tlp_perusahaan          = $rowPerusahaan['no_tlp'];
$no_wa_perusahaan           = $rowPerusahaan['no_wa'];
$email_perusahaan           = $rowPerusahaan['email'];
$alamat_perusahaan          = $rowPerusahaan['alamat'];
$nama_provinsi_perusahaan   = $rowPerusahaan['nama_provinsi'];
$nama_kota_perusahaan       = $rowPerusahaan['nama_kota'];
$nama_kecamatan_perusahaan  = $rowPerusahaan['nama_kecamatan'];
$no_rekening_perusahaan     = $rowPerusahaan['no_rekening'];

$smtp_host                  = $rowPerusahaan['smtp_host'];
$smtp_username              = $rowPerusahaan['smtp_username'];
$smtp_password              = $rowPerusahaan['smtp_password'];
$smtp_secure                = $rowPerusahaan['smtp_secure'];
$smtp_port                  = $rowPerusahaan['smtp_port'];

$favicon                    = $rowPerusahaan['favicon'];
$bg_login                   = $rowPerusahaan['bg_login'];
$logo_login                 = $rowPerusahaan['logo_login'];
$logo_home                  = $rowPerusahaan['logo_home'];
$small_logo                 = $rowPerusahaan['small_logo'];
?>
