<?php
$bulanini = date('Y-m');
$sqlPemasukan = mysqli_query($conn, "SELECT SUM(total_nilai) as total_pemasukan FROM transaksi_mutasi WHERE LEFT(tgl_mutasi, 7) = '$bulanini' AND jenis_transaksi = 'Pemasukan'");
$rowPemasukan = mysqli_fetch_array($sqlPemasukan);
$cekPemasukan = mysqli_num_rows($sqlPemasukan);
if($cekPemasukan > 0) {
    $pemasukan = $rowPemasukan['total_pemasukan'];
} else {
    $pemasukan = 0;
}

$sqlPengeluaran = mysqli_query($conn, "SELECT SUM(total_nilai) as total_pengeluaran FROM transaksi_mutasi WHERE LEFT(tgl_mutasi, 7) = '$bulanini' AND jenis_transaksi = 'Pengeluaran'");
$rowPengeluaran = mysqli_fetch_array($sqlPengeluaran);
$cekPengeluaran = mysqli_num_rows($sqlPengeluaran);
if($cekPengeluaran > 0) {
    $pengeluaran = $rowPengeluaran['total_pengeluaran'];
} else {
    $pengeluaran = 0;
}

$sqlKamarTersedia = mysqli_query($conn, "SELECT COUNT(*) as kamar_tersedia FROM master_kamar WHERE status = 'Tersedia'");
$rowKamarTersedia = mysqli_fetch_array($sqlKamarTersedia);
$cekKamarTersedia = mysqli_num_rows($sqlKamarTersedia);
if($cekKamarTersedia > 0) {
    $kamar_tersedia = $rowKamarTersedia['kamar_tersedia'];
} else {
    $kamar_tersedia = 0;
}

$sqlKamarTidakTersedia = mysqli_query($conn, "SELECT COUNT(*) as kamar_tidak_tersedia FROM master_kamar WHERE status = 'Tidak Tersedia'");
$rowKamarTidakTersedia = mysqli_fetch_array($sqlKamarTidakTersedia);
$cekKamarTidakTersedia = mysqli_num_rows($sqlKamarTidakTersedia);
if($cekKamarTidakTersedia > 0) {
    $kamar_tidak_tersedia = $rowKamarTidakTersedia['kamar_tidak_tersedia'];
} else {
    $kamar_tidak_tersedia = 0;
}

$sqlPenghuni = mysqli_query($conn, "SELECT COUNT(*) as total_penghuni FROM master_penghuni");
$rowPenghuni = mysqli_fetch_array($sqlPenghuni);
$cekPenghuni = mysqli_num_rows($sqlPenghuni);
if($cekPenghuni > 0) {
    $total_penghuni = $rowPenghuni['total_penghuni'];
} else {
    $total_penghuni = 0;
}

$sqlUser = mysqli_query($conn, "SELECT COUNT(*) as total_user FROM tb_admin");
$rowUser = mysqli_fetch_array($sqlUser);
$cekUser = mysqli_num_rows($sqlUser);
if($cekUser > 0) {
    $total_user = $rowUser['total_user'];
} else {
    $total_user = 0;
}
?>
<div class="content-wrapper">
    <div class="row">
        <div class="col-md-12 grid-margin">
            <div class="card bg-white">
                <div class="card-body d-flex align-items-center justify-content-between">
                    <h6 class="mt-1 mb-1" style="font-weight:normal;">Selamat Datang, di <b><?php echo $nama_aplikasi; ?></b></h6>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-6 grid-margin">
            <div class="row">
                <div class="col-md-6 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <p class="card-title">Pemasukan</p>
                            <div class="d-flex flex-wrap align-items-baseline">
                                <h3 class="mr-3"><?php echo number_format($pemasukan); ?></h3>
                            </div>
                            <p class="mb-0 text-muted fonts-12">Pemasukan Bulan <?php echo date('F Y'); ?></p>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <p class="card-title">Pengeluaran</p>
                            <div class="d-flex flex-wrap align-items-baseline">
                                <h3 class="mr-3"><?php echo number_format($pengeluaran); ?></h3>
                            </div>
                            <p class="mb-0 text-muted fonts-12">Pengeluaran Bulan <?php echo date('F Y'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12 stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <p class="card-title">Harga Kamar</p>
                            <br>
                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr class="border-top-0">
                                            <th class="text-muted">No Kamar</th>
                                            <th class="text-muted">Harga Bulanan</th>
                                            <th class="text-muted">Harga Harian</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sqlTagihan = mysqli_query($conn, "SELECT * FROM master_kamar WHERE status = 'Tersedia' ORDER BY no_kamar ASC");
                                        while($rowTagihan = mysqli_fetch_array($sqlTagihan)):
                                        ?>
                                            <tr>
                                              <td><?php echo $rowTagihan['no_kamar']; ?></td>
                                              <td align="right"><?php echo number_format($rowTagihan['harga_bulanan'], 2); ?></td>
                                              <td align="right"><?php echo number_format($rowTagihan['harga_harian'], 2); ?></td>
                                            </tr>
                                        <?php endwhile; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-6 grid-margin stretch-card">
            <div class="card">
                <div class="card-body">
                    <p class="card-title">Kamar Terisi</p>
                    <br>
                    <div class="table-responsive">
                        <table id="myTable2" class="table table-striped">
                            <thead>
                                <tr class="border-top-0">
                                    <th class="text-muted">No Kamar</th>
                                    <th class="text-muted">Penghuni</th>
                                    <th class="text-muted">Lama Sewa</th>
                                    <th class="text-muted">Tanggal Sewa</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $sqlSewa = mysqli_query($conn, "
                                                    SELECT 
                                                        a.id_sewa,
                                                        b.no_kamar,
                                                        c.nama_penghuni
                                                    FROM 
                                                        master_sewa a
                                                    INNER JOIN 
                                                        master_kamar b ON a.id_kamar = b.id_kamar
                                                    INNER JOIN 
                                                        master_penghuni c ON a.id_penghuni = c.id_penghuni
                                                    WHERE 
                                                        a.status = 'Aktif' 
                                                    ORDER BY 
                                                        b.no_kamar ASC
                                                    ");
                                while($rowSewa = mysqli_fetch_array($sqlSewa)):
                                    $sqlDetail = mysqli_query($conn, "SELECT * FROM master_sewa_detail WHERE id_sewa = '$rowSewa[id_sewa]' ORDER BY id_sewa_detail DESC LIMIT 1");
                                    $rowDetail = mysqli_fetch_array($sqlDetail);
                                ?>
                                    <tr>
                                      <td><?php echo $rowSewa['no_kamar']; ?></td>
                                      <td><?php echo $rowSewa['nama_penghuni']; ?></td>
                                      <td><?php echo $rowDetail['id_lama_sewa'].'&nbsp;'.$rowDetail['nama_lama_sewa']; ?></td>
                                      <td><?php echo $rowDetail['tgl_masuk'].'<br>'.$rowDetail['tgl_selesai']; ?></td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <p class="card-title">Cashflow</p>
                    <div id="chartContainer" style="height: 300px; width: 100%;"></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-3 grid-margin stretch-card">
            <div class="card border-0 border-radius-2 bg-success">
                <div class="card-body">
                    <div class="d-flex flex-md-column flex-xl-row flex-wrap  align-items-center justify-content-between">
                        <div class="icon-rounded-inverse-success icon-rounded-lg">
                            <i class="mdi mdi-home"></i>
                        </div>
                        <div class="text-white">
                            <p class="font-weight-medium mt-md-2 mt-xl-0 text-md-center text-xl-left">Kamar Tersedia</p>
                            <div class="d-flex flex-md-column flex-xl-row flex-wrap align-items-baseline align-items-md-center align-items-xl-baseline">
                                <h3 class="mb-0 mb-md-1 mb-lg-0 mr-1"><?php echo number_format($kamar_tersedia); ?></h3>
                                <small class="mb-0">Unit</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 grid-margin stretch-card">
            <div class="card border-0 border-radius-2 bg-info">
                <div class="card-body">
                    <div class="d-flex flex-md-column flex-xl-row flex-wrap  align-items-center justify-content-between">
                        <div class="icon-rounded-inverse-info icon-rounded-lg">
                            <i class="mdi mdi-hotel"></i>
                        </div>
                        <div class="text-white">
                            <p class="font-weight-medium mt-md-2 mt-xl-0 text-md-center text-xl-left">Kamar Terisi</p>
                            <div class="d-flex flex-md-column flex-xl-row flex-wrap align-items-baseline align-items-md-center align-items-xl-baseline">
                                <h3 class="mb-0 mb-md-1 mb-lg-0 mr-1"><?php echo number_format($kamar_tidak_tersedia); ?></h3>
                                <small class="mb-0">Unit</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 grid-margin stretch-card">
            <div class="card border-0 border-radius-2 bg-danger">
                <div class="card-body">
                    <div class="d-flex flex-md-column flex-xl-row flex-wrap  align-items-center justify-content-between">
                        <div class="icon-rounded-inverse-danger icon-rounded-lg">
                            <i class="mdi mdi-account-multiple-outline"></i>
                        </div>
                        <div class="text-white">
                            <p class="font-weight-medium mt-md-2 mt-xl-0 text-md-center text-xl-left">Total Penghuni</p>
                            <div class="d-flex flex-md-column flex-xl-row flex-wrap align-items-baseline align-items-md-center align-items-xl-baseline">
                                <h3 class="mb-0 mb-md-1 mb-lg-0 mr-1"><?php echo number_format($total_penghuni); ?></h3>
                                <small class="mb-0">Orang</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3 grid-margin stretch-card">
            <div class="card border-0 border-radius-2 bg-warning">
                <div class="card-body">
                    <div class="d-flex flex-md-column flex-xl-row flex-wrap  align-items-center justify-content-between">
                        <div class="icon-rounded-inverse-warning icon-rounded-lg">
                            <i class="mdi mdi-account-key"></i>
                        </div>
                        <div class="text-white">
                            <p class="font-weight-medium mt-md-2 mt-xl-0 text-md-center text-xl-left">Total User</p>
                            <div class="d-flex flex-md-column flex-xl-row flex-wrap align-items-baseline align-items-md-center align-items-xl-baseline">
                                <h3 class="mb-0 mb-md-1 mb-lg-0 mr-1"><?php echo number_format($total_user); ?></h3>
                                <small class="mb-0">Orang</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <p class="card-title">Jatuh Tempo</p>
                    <div class="table-responsive">
                        <table id="myTable3" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Kamar</th>
                                    <th>Penghuni</th>
                                    <th>Jenis Sewa</th>
                                    <th>Jatuh Tempo</th>
                                    <th>Nilai</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $no = 1;
                                // $sqlJT        = mysqli_query($conn, "
                                //                     SELECT
                                //                         a.id_sewa, MAX(a.tgl_selesai) as tgl_selesai, a.grand_total,
                                //                         b.nama_jenis_sewa,
                                //                         c.nama_penghuni,
                                //                         d.no_kamar
                                //                     FROM 
                                //                         master_sewa_detail a
                                //                     INNER JOIN 
                                //                         master_sewa b ON a.id_sewa = b.id_sewa
                                //                     LEFT JOIN 
                                //                         master_penghuni c ON b.id_penghuni = c.id_penghuni
                                //                     LEFT JOIN 
                                //                         master_kamar d ON b.id_kamar = d.id_kamar
                                //                     WHERE
                                //                        b.status = 'Aktif' AND MAX(a.tgl_selesai) <= DATE_ADD(CURDATE(), INTERVAL 7 DAY)
                                //                     GROUP BY 
                                //                         a.id_sewa
                                //                     ");

                                $sqlJT = mysqli_query($conn, "
                                                SELECT
                                                    a.id_sewa, 
                                                    MAX(a.tgl_selesai) as tgl_selesai, 
                                                    a.grand_total,
                                                    b.nama_jenis_sewa,
                                                    c.nama_penghuni,
                                                    d.no_kamar
                                                FROM 
                                                    master_sewa_detail a
                                                INNER JOIN 
                                                    master_sewa b ON a.id_sewa = b.id_sewa
                                                LEFT JOIN 
                                                    master_penghuni c ON b.id_penghuni = c.id_penghuni
                                                LEFT JOIN 
                                                    master_kamar d ON b.id_kamar = d.id_kamar
                                                WHERE
                                                    b.status = 'Aktif'
                                                GROUP BY 
                                                    a.id_sewa
                                                HAVING 
                                                    MAX(a.tgl_selesai) <= DATE_ADD(CURDATE(), INTERVAL 7 DAY)
                                                ORDER BY 
                                                    a.id_sewa;
");
                                while ($rowJT = mysqli_fetch_array($sqlJT)):
                                ?>
                                    <tr>
                                      <td><?php echo $no++; ?></td>
                                      <td><?php echo $rowJT['no_kamar']; ?></td>
                                      <td><?php echo $rowJT['nama_penghuni']; ?></td>
                                      <td><?php echo $rowJT['nama_jenis_sewa']; ?></td>
                                      <td><?php echo $rowJT['tgl_selesai']; ?></td>
                                      <td align="right"><?php echo number_format($rowJT['grand_total'], 2); ?></td>
                                    </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<script src="https://cdn.canvasjs.com/canvasjs.min.js"></script>
<script>
$(document).ready(function() {
    $('#myTable').DataTable({});
    $('#myTable2').DataTable({});
    $('#myTable3').DataTable({});
});


window.onload = function () {
    var chart = new CanvasJS.Chart("chartContainer", {
        animationEnabled: true,
        theme: "light2",
        title:{
            text: "Cashflow Tahun <?php echo $years; ?>",
            fontSize: 12,
            fontFamily: "Poppins",
            margin: 20,
        },
        axisX:{
            valueFormatString: "MMM",
            crosshair: {
                enabled: true,
                snapToDataPoint: true
            }
        },
        axisY: {
            title: "Rupiah",
            includeZero: true,
            crosshair: {
                enabled: true
            }
        },
        toolTip:{
            shared:true
        },
        legend:{
            cursor:"pointer",
            verticalAlign: "bottom",
            horizontalAlign: "left",
            dockInsidePlotArea: true,
            itemclick: toogleDataSeries
        },
        data: [{
            type: "line",
            showInLegend: true,
            name: "Pemasukan",
            markerType: "square",
            xValueFormatString: "MMM YYYY",
            color: "#3da5f4",
            dataPoints: [
                <?php
                 $sql   = mysqli_query($conn, "
                                SELECT
                                    a.bulan,
                                    IFNULL(b.total_pemasukan, 0) as total_pemasukan
                                FROM
                                    setup_bulan a
                                LEFT JOIN (
                                        SELECT
                                            substr(tgl_mutasi, 6, 2) as bulan_transaksi,
                                            SUM(total_nilai) as total_pemasukan
                                        FROM
                                            transaksi_mutasi
                                        WHERE
                                            left(tgl_mutasi, 4) = '$years' AND
                                            jenis_transaksi = 'Pemasukan'
                                        GROUP BY
                                            left(tgl_mutasi, 7)
                                    ) b ON a.bulan = b.bulan_transaksi
                                ORDER BY
                                    a.bulan ASC
                                ");
                while($row = mysqli_fetch_array($sql)):
                ?>
                    { x: new Date(<?php echo $years; ?>, <?php echo $row['bulan']-1; ?>),  y: <?php echo $row['total_pemasukan']; ?> },
                <?php endwhile; ?>
            ]
        },
        {
            type: "line",
            showInLegend: true,
            name: "Pengeluaran",
            lineDashType: "dash",
            color:"#ee3050",
            dataPoints: [
               <?php
                 $sql   = mysqli_query($conn, "
                                SELECT
                                    a.bulan,
                                    IFNULL(b.total_pengeluaran, 0) as total_pengeluaran
                                FROM
                                    setup_bulan a
                                LEFT JOIN (
                                        SELECT
                                            substr(tgl_mutasi, 6, 2) as bulan_transaksi,
                                            SUM(total_nilai) as total_pengeluaran
                                        FROM
                                            transaksi_mutasi
                                        WHERE
                                            left(tgl_mutasi, 4) = '$years' AND
                                            jenis_transaksi = 'Pengeluaran'
                                        GROUP BY
                                            left(tgl_mutasi, 7)
                                    ) b ON a.bulan = b.bulan_transaksi
                                ORDER BY
                                    a.bulan ASC
                                ");
                while($row = mysqli_fetch_array($sql)):
                ?>
                    { x: new Date(<?php echo $years; ?>, <?php echo $row['bulan']-1; ?>),  y: <?php echo $row['total_pengeluaran']; ?> },
                <?php endwhile; ?>
            ]
        }]
    });
    chart.render();

    function toogleDataSeries(e){
        if (typeof(e.dataSeries.visible) === "undefined" || e.dataSeries.visible) {
            e.dataSeries.visible = false;
        } else{
            e.dataSeries.visible = true;
        }
        chart.render();
    }

}
</script>
