<div class="content-wrapper">
    <div class="page-titles">
        <ol class="breadcrumb breadcrumb-custom">
            <li class="breadcrumb-item"><a href="<?php echo $base_url; ?>/dashboard">Dashbboard</a></li>
            <?php
            for ($i = 0; $i < count($parts); $i++) {
                if ($i == count($parts) - 1) {
                    // Jika ini adalah kata terakhir, tambahkan kelas "active"
                    echo '<li class="breadcrumb-item active" aria-current="page">' . ucfirst($parts[$i]) . '</li>';
                } else {
                    // Jika bukan kata terakhir, tambahkan tautan
                    echo '<li class="breadcrumb-item"><a href="#">' . ucfirst($parts[$i]) . '</a></li>';
                }
            }
            ?>
        </ol>
    </div>

    <?php $type = 'tambah'; ?>
    <form id="form<?php echo $type; ?>" method="post" autocomplete="off">
    <input type="hidden" name='idadmin' value="<?php echo $idadmin; ?>" />
    <input type="hidden" name='type' value="<?php echo $type; ?>">

    <div class="row">
        <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-12">
                            <h4 class="card-title"><i class="mdi mdi-lead-pencil mr-1"></i> Form</h4>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h4 class="card-title">Informasi Penghuni</h4>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Lokasi <code>*</code></label>
                                        <div class="col-sm-9">
                                            <select class="form-control form-control-sm form-select select2" name="id_lokasi" id="id_lokasi" style="width: 100%;" required="">
                                                <option value="">【 Pilih 】</option>
                                                <?php
                                                $sqlLokasi = mysqli_query($conn, "SELECT * FROM master_lokasi ORDER BY nama_lokasi ASC");
                                                while($rowLokasi = mysqli_fetch_array($sqlLokasi)):
                                                ?>
                                                    <option value="<?php echo $rowLokasi['id_lokasi']; ?>"><?php echo $rowLokasi['nama_lokasi']; ?></option>
                                                <?php
                                                endwhile;
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Lantai <code>*</code></label>
                                        <div class="col-sm-9">
                                            <select class="form-control form-control-sm form-select select2" name="id_lantai" id="id_lantai" style="width: 100%;" required="">
                                                <option value="">【 Pilih 】</option>
                                                <?php
                                                $sqlLantai = mysqli_query($conn, "SELECT * FROM master_lantai ORDER BY nama_lantai ASC");
                                                while($rowLantai = mysqli_fetch_array($sqlLantai)):
                                                ?>
                                                    <option value="<?php echo $rowLantai['id_lantai']; ?>"><?php echo $rowLantai['nama_lantai']; ?></option>
                                                <?php
                                                endwhile;
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">No Kamar <code>*</code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="no_kamar" id="no_kamar" maxlength="255" required="">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Hrg Bulanan <code>*</code></label>
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control form-control-sm" name="harga_bulanan" id="harga_bulanan" required="" value="0">
                                        </div>
                                        <label class="col-sm-3 col-form-label">/ Bulan</label>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Hrg Harian <code>*</code></label>
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control form-control-sm" name="harga_harian" id="harga_harian" required="" value="0">
                                        </div>
                                        <label class="col-sm-3 col-form-label">/ Hari</label>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Foto <code></code></label>
                                        <div class="col-sm-9">
                                            <input type="file" class="form-control form-control-sm" name="file_foto" id="file_foto">
                                            <span class="text-muted fonts-12"><i>Maksimal file 500 KB</i></span>
                                        </div>
                                    </div>

                                    <hr style="border-top: 1px dashed #03a9f3;">
                                    <div class="row mb-2 mt-4">
                                        <div class="col-lg-12">
                                            <div style="float: left;">
                                                <button type="submit" class="btn btn-info btn-icon-text mr-1" style="padding-top:12px;"><i class="mdi mdi-content-save" style="padding-top:4px;"></i> Simpan</button>

                                                <button type="button" class="btn btn-warning btn-icon-text mr-1" style="padding-top:12px;" onclick="refresh();"><i class="mdi mdi-refresh" style="padding-top:4px;"></i> Refresh</button>

                                                <a href="<?php echo $base_url; ?>/daftar/kamar" class="btn btn-danger btn-icon-text" style="padding-top:12px;"><i class="mdi mdi-arrow-left" style="padding-top:4px;"></i> Kembali</a>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mt-3">
                                        <div class="col-lg-12">
                                            <div id="hasil<?php echo $type; ?>">
                                                <div class="spinner<?php echo $type; ?>" style="display: none;">
                                                    <i class="mr-1 fonts-12">Proses Simpan ...</i><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h4 class="card-title">Informasi Tambahan</h4>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Fasilitas</label>
                                        <div class="col-sm-9">
                                            <textarea id="fasilitas" name="fasilitas"></textarea>
                                            <span class="text-muted fonts-12"><i>Contoh Falisitas kamar seperti: Kasur/Tempat Tidur, AC, Lemari Baju, TV, Km.Dalam dll.</i></span>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Kelengkapan</label>
                                        <div class="col-sm-9">
                                            <textarea id="kelengkapan" name="kelengkapan"></textarea>
                                            <span class="text-muted fonts-12"><i>Untuk Mencegah kehilangan atau kerusakan anda dapat mencantumkan kelengkapan kamar yang diberikan ke penyewa, contoh seperti Kunci Kamar 1pcs, Remot AC, Remot TV, Kunci Gerbang dll.</i></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    </form>
</div>

<script src="<?php echo $base_url; ?>/vendor/tinymce/tinymce.min.js"></script>
<script type="text/javascript">
    tinymce.init({
      selector: '#fasilitas',
      height: 300,
      plugins: [
        'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
        'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
        'insertdatetime', 'media', 'table', 'help', 'wordcount'
      ],
      toolbar: 'undo redo | blocks | ' +
      'bold italic backcolor | alignleft aligncenter ' +
      'alignright alignjustify | bullist numlist outdent indent | ' +
      'removeformat | help',
      content_style: 'body { font-family:Poppins; font-size:12px }'
    });


    tinymce.init({
      selector: '#kelengkapan',
      height: 300,
      plugins: [
        'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
        'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
        'insertdatetime', 'media', 'table', 'help', 'wordcount'
      ],
      toolbar: 'undo redo | blocks | ' +
      'bold italic backcolor | alignleft aligncenter ' +
      'alignright alignjustify | bullist numlist outdent indent | ' +
      'removeformat | help',
      content_style: 'body { font-family:Poppins; font-size:12px }'
    });
</script>

<script type="text/javascript">
    $(document).ready(function(e) {
        $('.select2').select2();

        $("#modal_<?php echo $type; ?>").on('shown.bs.modal', function () {
            $('#no_kamar').focus();
        });

        harga_bulanan.addEventListener('input', function() {
            harga_bulanan.value = formatRibuan(this.value);
        });

        harga_harian.addEventListener('input', function() {
            harga_harian.value = formatRibuan(this.value);
        });


        $("#form<?php echo $type; ?>").on('submit', (function(e) {
            e.preventDefault();
            $.ajax({
                url: '<?php echo $base_url; ?>/pages/kamar/kamar/proses.php',
                type: "POST",
                data: new FormData(this),
                contentType: false,
                cache: false,
                processData: false,
                beforeSend: function() {
                    $(".spinner<?php echo $type; ?>").css("display", "block");
                    $("#hasil<?php echo $type; ?>").show();
                },
                success: function(data) {
                    $("#hasil<?php echo $type; ?>").html(data);
                    $(".spinner<?php echo $type; ?>").css("display", "none");
                    
                    setTimeout(function() {
                        $("#hasil<?php echo $type; ?>").hide(data);
                    }, 1500);
                },
                error: function() {}
            })
        }));
    });
</script>
