<?php
include_once('../../../include/koneksi.php');
?>

<?php if ($_GET['page'] == 'formdata-tambah') { ?>

    <?php
    $idadmin   = $_POST['idadmin'];
    $type      = "tambah";
    $link_hak_akses_menu = $_GET['link_hak_akses_menu'];
    ?>

    <form id="form<?php echo $type; ?>" method="post" autocomplete="off">
        <input type="hidden" name='idadmin' value="<?php echo $idadmin; ?>" />
        <input type="hidden" name='type' value="<?php echo $type; ?>">

        <div class="modal-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Tanggal <code>*</code></label>
                        <input type="date" class="form-control form-control-sm" name="tgl_pengeluaran" id="tgl_pengeluaran" required="">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Kategori <code>*</code></label>
                        <select class="form-control form-control-sm form-select select2" name="kategori_transaksi" id="kategori_transaksi" style="width: 100%;" required="">
                            <option value="">【 Pilih 】</option>
                            <?php
                            $sqlKategori = mysqli_query($conn, "SELECT * FROM master_kategori_transaksi ORDER BY kategori_transaksi ASC");
                            while($rowKategori = mysqli_fetch_array($sqlKategori)):
                            ?>
                                <option value="<?php echo $rowKategori['kategori_transaksi']; ?>"><?php echo $rowKategori['kategori_transaksi']; ?></option>
                            <?php
                            endwhile;
                            ?>
                        </select>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Nama <code>*</code></label>
                        <input type="text" class="form-control form-control-sm" maxlength="255" name="nama_pengeluaran" id="nama_pengeluaran" required="">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Keterangan <code></code></label>
                        <textarea class="form-control form-control-sm" rows="4" name="keterangan" id="keterangan"></textarea>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Nilai <code>*</code></label>
                        <input type="text" class="form-control form-control-sm" maxlength="255" name="total_nilai" id="total_nilai" required="">
                    </div>
                </div>
            </div>
        </div>

        <div class="modal-body" style="border-top: 1px solid #e4e9f0;">
            <div class="row mb-2">
                <div class="col-lg-6">
                    &nbsp;
                </div>
                <div class="col-lg-6">
                    <div style="float: right;">
                        <button type="submit" class="btn btn-sm btn-info btn-icon-text"><i class="mdi mdi-content-save"></i> Simpan</button>
                        <button type="button" class="btn btn-sm btn-danger btn-icon-text" data-dismiss="modal"><i class="mdi mdi-close"></i> Tutup</button>
                    </div>
                </div>
            </div>

            <div class="row mt-3">
                <div class="col-lg-12">
                    <div id="hasil<?php echo $type; ?>">
                        <div class="spinner<?php echo $type; ?>" style="display: none;">
                            <i class="mr-1 fonts-12">Proses Simpan ...</i><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <script type="text/javascript">
        $(document).ready(function(e) {

            $('.select2').select2();

            total_nilai.addEventListener('input', function() {
                total_nilai.value  = formatRibuan(this.value);
            });


            $("#form<?php echo $type; ?>").on('submit', (function(e) {
                e.preventDefault();
                $.ajax({
                    url: '<?php echo $base_url; ?>/pages/keuangan/pengeluaran/proses.php',
                    type: "POST",
                    data: new FormData(this),
                    contentType: false,
                    cache: false,
                    processData: false,
                    beforeSend: function() {
                        $(".spinner<?php echo $type; ?>").css("display", "block");
                        $("#hasil<?php echo $type; ?>").show();
                    },
                    success: function(data) {
                        $("#hasil<?php echo $type; ?>").html(data);
                        $(".spinner<?php echo $type; ?>").css("display", "none");

                        $("#tgl_pengeluaran").val('');
                        $("#nama_pengeluaran").val('');
                        $("#keterangan").val('');
                        $("#total_nilai").val('');
                        $("#kategori_transaksi").val(null).trigger('change');

                        setTimeout(function() {
                            $("#hasil<?php echo $type; ?>").hide(data);
                            $("#data_lokasi").load("<?php echo $base_url; ?>/pages/keuangan/pengeluaran/data.php?page=data-pengeluaran&idadmin=<?php echo $idadmin; ?>&link_hak_akses_menu=<?php echo $link_hak_akses_menu; ?>");
                        }, 1500);
                    },
                    error: function() {}
                })
            }));
        });
    </script>

<?php } ?>


<?php if ($_GET['page'] == 'formdata-rubah') { ?>

    <?php
    $id_pengeluaran  = $_POST['id'];
    $idadmin      = $_POST['idadmin'];
    $type         = "rubah";
    $link_hak_akses_menu = $_GET['link_hak_akses_menu'];
    
    $sql          = mysqli_query($conn, "SELECT * FROM transaksi_pengeluaran WHERE id_pengeluaran = '$id_pengeluaran'");
    $row          = mysqli_fetch_array($sql);
    ?>

    <form id="form<?php echo $type; ?>" method="post" autocomplete="off">
        <input type="hidden" name='id_pengeluaran' value="<?php echo $id_pengeluaran; ?>" />
        <input type="hidden" name='no_pengeluaran' value="<?php echo $row['no_pengeluaran']; ?>" />
        <input type="hidden" name='idadmin' value="<?php echo $idadmin; ?>" />
        <input type="hidden" name='type' value="<?php echo $type; ?>">

        <div class="modal-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Tanggal <code>*</code></label>
                        <input type="date" class="form-control form-control-sm" name="tgl_pengeluaran" id="tgl_pengeluaran" required="" value="<?php echo $row['tgl_pengeluaran']; ?>">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Kategori <code>*</code></label>
                        <select class="form-control form-control-sm form-select select2" name="kategori_transaksi" id="kategori_transaksi" style="width: 100%;" required="">
                            <option value="">【 Pilih 】</option>
                            <?php
                            $sqlKategori = mysqli_query($conn, "SELECT * FROM master_kategori_transaksi ORDER BY kategori_transaksi ASC");
                            while($rowKategori = mysqli_fetch_array($sqlKategori)):
                            ?>
                                <option value="<?php echo $rowKategori['kategori_transaksi']; ?>" <?php if($row['kategori_transaksi'] == $rowKategori['kategori_transaksi']) echo 'selected'; ?> ><?php echo $rowKategori['kategori_transaksi']; ?></option>
                            <?php
                            endwhile;
                            ?>
                        </select>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Nama <code>*</code></label>
                        <input type="text" class="form-control form-control-sm" maxlength="255" name="nama_pengeluaran" id="nama_pengeluaran" required="" value="<?php echo $row['nama_pengeluaran']; ?>">
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Keterangan <code></code></label>
                        <textarea class="form-control form-control-sm" rows="4" name="keterangan" id="keterangan"><?php echo $row['keterangan']; ?></textarea>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <div class="form-group">
                        <label>Nilai <code>*</code></label>
                        <input type="text" class="form-control form-control-sm" maxlength="255" name="total_nilai" id="total_nilai" required="" value="<?php echo number_format($row['total_nilai']); ?>">
                    </div>
                </div>
            </div>
        </div>

        <div class="modal-body" style="border-top: 1px solid #e4e9f0;">
            <div class="row mb-2">
                <div class="col-lg-6">
                    &nbsp;
                </div>
                <div class="col-lg-6">
                    <div style="float: right;">
                        <button type="submit" class="btn btn-sm btn-info btn-icon-text"><i class="mdi mdi-content-save"></i> Simpan</button>
                        <button type="button" class="btn btn-sm btn-danger btn-icon-text" data-dismiss="modal"><i class="mdi mdi-close"></i> Tutup</button>
                    </div>
                </div>
            </div>

            <div class="row mt-3">
                <div class="col-lg-12">
                    <div id="hasil<?php echo $type; ?>">
                        <div class="spinner<?php echo $type; ?>" style="display: none;">
                            <i class="mr-1 fonts-12">Proses Simpan ...</i><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <script type="text/javascript">
        $(document).ready(function(e) {

            $('.select2').select2();

            total_nilai.addEventListener('input', function() {
                total_nilai.value  = formatRibuan(this.value);
            });


            $("#form<?php echo $type; ?>").on('submit', (function(e) {
                e.preventDefault();
                $.ajax({
                    url: '<?php echo $base_url; ?>/pages/keuangan/pengeluaran/proses.php',
                    type: "POST",
                    data: new FormData(this),
                    contentType: false,
                    cache: false,
                    processData: false,
                    beforeSend: function() {
                        $(".spinner<?php echo $type; ?>").css("display", "block");
                        $("#hasil<?php echo $type; ?>").show();
                    },
                    success: function(data) {
                        $("#hasil<?php echo $type; ?>").html(data);
                        $(".spinner<?php echo $type; ?>").css("display", "none");

                        // setTimeout(function() {
                        //     $("#hasil<?php echo $type; ?>").hide(data);
                        //     $("#data_lokasi").load("<?php echo $base_url; ?>/pages/keuangan/pengeluaran/data.php?page=data-pengeluaran&idadmin=<?php echo $idadmin; ?>&link_hak_akses_menu=<?php echo $link_hak_akses_menu; ?>");
                        // }, 1500);
                    },
                    error: function() {}
                })
            }));
        });
    </script>

<?php } ?>


<?php if ($_GET['page'] == 'formdata-hapus') { ?>

    <?php
    $id_pengeluaran   = $_POST['id'];
    $type      = "hapus";
    ?>

    <form id="form<?php echo $type; ?>" method="post" autocomplete="off">
        <input type="hidden" name='id_pengeluaran' value="<?php echo $id_pengeluaran; ?>" />
        <input type="hidden" name='type' value="<?php echo $type; ?>">

        <div class="modal-body">
            <div class="alert alert-warning">
                <span class="alert-title">Apakah anda yakin akan menghapus ? Proses ini tidak bisa di kembalikan.</span>
            </div>
        </div>

        <div class="modal-body" style="border-top: 1px solid #e4e9f0;">
            <div class="row mb-2">
                <div class="col-lg-6">
                    &nbsp;
                </div>
                <div class="col-lg-6">
                    <div style="float: right;">
                        <button type="submit" class="btn btn-sm btn-info btn-icon-text"><i class="mdi mdi-content-save"></i> Simpan</button>
                        <button type="button" class="btn btn-sm btn-danger btn-icon-text" data-dismiss="modal"><i class="mdi mdi-close"></i> Tutup</button>
                    </div>
                </div>
            </div>

            <div class="row mt-3">
                <div class="col-lg-12">
                    <div id="hasil<?php echo $type; ?>">
                        <div class="spinner<?php echo $type; ?>" style="display: none;">
                            <i class="mr-1 fonts-12">Proses Simpan ...</i><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <script type="text/javascript">
        $(document).ready(function(e) {
            $("#form<?php echo $type; ?>").on('submit', (function(e) {
                e.preventDefault();
                $.ajax({
                    url: '<?php echo $base_url; ?>/pages/keuangan/pengeluaran/proses.php',
                    type: "POST",
                    data: new FormData(this),
                    contentType: false,
                    cache: false,
                    processData: false,
                    beforeSend: function() {
                        $(".spinner<?php echo $type; ?>").css("display", "block");
                        $("#hasil<?php echo $type; ?>").show();
                    },
                    success: function(data) {
                        $("#hasil<?php echo $type; ?>").html(data);
                        $(".spinner<?php echo $type; ?>").css("display", "none");
                    },
                    error: function() {}
                })
            }));
        });
    </script>

<?php } ?>