<div class="content-wrapper">
    <div class="page-titles">
        <ol class="breadcrumb breadcrumb-custom">
            <li class="breadcrumb-item"><a href="<?php echo $base_url; ?>/dashboard">Dashbboard</a></li>
            <?php
            for ($i = 0; $i < count($parts); $i++) {
                if ($i == count($parts) - 1) {
                    // Jika ini adalah kata terakhir, tambahkan kelas "active"
                    echo '<li class="breadcrumb-item active" aria-current="page">' . ucfirst($parts[$i]) . '</li>';
                } else {
                    // Jika bukan kata terakhir, tambahkan tautan
                    echo '<li class="breadcrumb-item"><a href="#">' . ucfirst($parts[$i]) . '</a></li>';
                }
            }
            ?>
        </ol>
    </div>

    <div class="row">
        <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-12">
                            <h4 class="card-title"><i class="mdi mdi-view-list mr-1"></i> Data</h4>  
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <?php 
                    // Tanggal awal bulan ini
                    $tanggal_awal = date('Y-m-01');

                    // Tanggal akhir bulan ini
                    $tanggal_akhir = date('Y-m-t');
                    ?>

                    <form id="form" method="post" autocomplete="off">
                        <div class="row mb-2">
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label>Tgl Mulai <code>*</code></label>
                                    <input type="date" class="form-control form-control-sm" name="tgl_awal" id="tgl_awal" required="" value="<?php echo $tanggal_awal; ?>">
                                </div>
                            </div>

                            <div class="col-md-2">
                                <div class="form-group">
                                     <label>Tgl Sampai<code>*</code></label>
                                    <input type="date" class="form-control form-control-sm" name="tgl_akhir" id="tgl_akhir" required="" value="<?php echo $tanggal_akhir; ?>">
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="form-group">
                                    <label>&nbsp;<code></code></label>
                                    <div>
                                        <button type="submit" class="btn btn-sm btn-info btn-icon-text mt-0 mr-2" style="float: left; padding-top: 9px; padding-bottom: 9px;">
                                            <i class="mdi mdi-file-find" style="padding-top:1px;"></i> Tampilkan
                                        </button>

                                        <div class="btn-excel" style="display:none; float: left;">
                                                <button type="button" id="download-excel" class="btn btn-sm btn-warning btn-icon-text mt-0 mr-2" style="float: left; padding-top: 9px; padding-bottom: 9px;">
                                                    <i class="mdi mdi-file-excel" style="padding-top:1px;"></i> Excel
                                                </button>

                                                <button type="button" id="print" class="btn btn-sm btn-dark btn-icon-text mt-0" style="float: left; padding-top: 9px; padding-bottom: 9px;">
                                                    <i class="mdi mdi-printer" style="padding-top:1px;"></i> Print
                                                </button>
                                        </div>

                                        <div class="d-flex justify-content-center">
                                            <div class="spinner" style="display:none;">
                                                <i class="mr-1" style="color:#000; font-size:13px;">Proses Cari ...</i><span class="spinner-border spinner-border-sm mb-1" role="status" aria-hidden="true"></span>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                            </div>
                        </div>                              
                    </form>
                    
                    <hr class="mt-4 mb-4">

                    <div id="hasil_cari"></div>
                    
                </div>
            </div>
        </div>
    </div>
</div>


<script src="<?php echo $base_url; ?>/assets/js/xlsx.full.min.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
         $("#download-excel").on('click', function (e) {
            var table = document.getElementById('myTable');
            var wb = XLSX.utils.table_to_book(table, {sheet: "Sheet1"});
            var tgl_awal = $('#tgl_awal').val();
            var tgl_akhir = $('#tgl_akhir').val();


            XLSX.writeFile(wb, 'Laporan Pemasukan '+tgl_awal+' - ' +tgl_akhir+'.xlsx');
        });

        $("#print").on('click', function (event) {
            event.preventDefault();  // Prevent the default action
        
            var tgl_awal = document.getElementById("tgl_awal").value;
            var tgl_akhir = document.getElementById("tgl_akhir").value;

            // Construct the URL
            var base_url = "<?php echo $base_url; ?>";
            var href = base_url + "/laporan/pengeluaran/cetak/"+ tgl_awal + "/" + tgl_akhir;

            // Update the href attribute
            $(this).attr('href', href);

            window.open(href, '_blank');
        });
    });
</script>

<script type="text/javascript">
    $(document).ready(function (e) {

        $("#form").on('submit',(function(e) {
            e.preventDefault();
            $.ajax({
                url                 : "<?php echo $base_url; ?>/pages/laporan/pengeluaran/data.php?page=data-cari",
                type                : "POST",
                data                : new FormData(this),
                contentType         : false,
                cache               : false,
                processData         : false,
                beforeSend          : function(){
                                            $(".spinner").css("display","block");
                                            $(".btn-excel").css("display","none");
                                        },
                success             : function(data) {
                                            $("#hasil_cari").html(data);
                                            $(".spinner").css("display","none");
                                            $(".btn-excel").css("display","block");
                                        },
                error    :   function() {}
             })
        }));
    });
</script>


