
<!DOCTYPE html>
<html lang="en">
  <head>
    <link rel="shortcut icon" href="../../../assets/img/<?php echo $favicon; ?>" />
    <link rel="stylesheet" href="../../../vendor/mdi/css/materialdesignicons.min.css"/>
    <link rel="stylesheet" href="../../../assets/css/vendor.bundle.base.css" />
    <link rel="stylesheet" href="../../../vendor/datatables/dataTables.bootstrap4.css">

    <link rel="stylesheet" href="../../../assets/css/style.css" />

    <!-- Autocomplete -->
    <link rel="stylesheet" href="../../../vendor/autocomplete/jquery-ui.css">

    <link rel="stylesheet" href="../../../vendor/select2/select2.min.css" />
<script type="text/javascript" src="../../../assets/js/jquery.js"></script>
  </head>

<div class="content-wrapper">
    <div class="page-titles">
        <ol class="breadcrumb breadcrumb-custom">
            <li class="breadcrumb-item"><a href="<?php echo $base_url; ?>/dashboard">Dashbboard</a></li>
            <?php
            for ($i = 0; $i < count($parts); $i++) {
                if ($i == count($parts) - 1) {
                    // Jika ini adalah kata terakhir, tambahkan kelas "active"
                    echo '<li class="breadcrumb-item active" aria-current="page">' . ucfirst($parts[$i]) . '</li>';
                } else {
                    // Jika bukan kata terakhir, tambahkan tautan
                    echo '<li class="breadcrumb-item"><a href="#">' . ucfirst($parts[$i]) . '</a></li>';
                }
            }
            ?>
        </ol>
    </div>


    <?php $type = 'tambah'; ?>
    <form id="form<?php echo $type; ?>" method="post" autocomplete="off">
    <input type="hidden" name='idadmin' value="<?php echo $idadmin; ?>" />
    <input type="hidden" name='type' value="<?php echo $type; ?>">

    <div class="row">
        <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-12">
                            <h4 class="card-title"><i class="mdi mdi-lead-pencil mr-1"></i> Form</h4>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h4 class="card-title">Informasi Penghuni</h4>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Penghuni <code>*</code></label>
                                        <div class="col-sm-9">
                                            <select class="form-control form-control-sm form-select select2" name="id_penghuni" id="id_penghuni" style="width: 100%;" required="">
                                                <option value="">【 Pilih 】</option>
                                                <?php
                                                $sqlPenghuni = mysqli_query($conn, "SELECT * FROM master_penghuni ORDER BY nama_penghuni ASC");
                                                while($rowPenghuni = mysqli_fetch_array($sqlPenghuni)):
                                                ?>
                                                    <option value="<?php echo $rowPenghuni['id_penghuni']; ?>"><?php echo $rowPenghuni['nama_penghuni']; ?></option>
                                                <?php
                                                endwhile;
                                                ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Tgl Masuk <code>*</code></label>
                                        <div class="col-sm-9">
                                            <input type="date" class="form-control form-control-sm" name="tgl_masuk" id="tgl_masuk" required="">
                                            <p class="mb-0 text-muted fonts-12"><i>Jika Tgl Masuk 31 maka Tagihan Bulan Depan adalah Tgl 30. Dst</i></p>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Tgl Selesai <code>*</code></label>
                                        <div class="col-sm-9">
                                            <input type="date" class="form-control form-control-sm" id="tgl_selesai" disabled>
                                            <input type="hidden" class="form-control form-control-sm" name="tgl_selesai" id="tgl_selesai_2">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h4 class="card-title">Informasi Sewa</h4>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Jenis Sewa <code>*</code></label>
                                        <div class="col-sm-9">
                                            <select class="form-control form-control-sm form-select select2" name="jenis_sewa" id="jenis_sewa" style="width: 100%;">
                                                <option value="0~>Pilih">【 Pilih 】</option>
                                                <option value="1~>Harian">Harian</option>
                                                <option value="2~>Bulanan">Bulanan</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Kamar <code>*</code></label>
                                        <div class="col-sm-9">
                                            <select class="form-control form-control-sm form-select select2" name="kamar" id="kamar" style="width: 100%;" required="">
                                                <option value="0~>0">【 Pilih 】</option>
                                            </select>
                                        </div>
                                    </div>


                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Lama Sewa <code>*</code></label>
                                        <div class="col-sm-9">
                                            <select class="form-control form-control-sm form-select select2" name="lama_sewa" id="lama_sewa" style="width: 100%;" required="">
                                                <option value="0~>Pilih">【 Pilih 】</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-12">
                            <h4 class="card-title">Tambahan Biaya</h4>
                            <div class="table-responsive">
                                <table id="" class="table" style="width:100%;">
                                    <thead>
                                        <tr>
                                            <th width="70%" style="background:none; padding-bottom: 12px;">Keterangan Detail</th>
                                            <th width="20%" style="background:none; padding-bottom: 12px;">Nilai</th>
                                            <th width="10%" style="background:none; padding-bottom: 12px;">&nbsp;</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="pt-2 pr-0 pb-0">
                                                <input type="text" class="form-control form-control-sm" name="keterangan_detail" id="keterangan_detail">
                                            </td>
                                            <td class="pt-2 pr-0 pb-0">
                                                <input type="text" class="form-control form-control-sm" name="nilai" id="nilai" style="text-align:right;" value="0">
                                            </td>
                                            <td class="pt-2 pr-0 pb-0" align="center">
                                                <button type="button" class="btn btn-sm btn-default tambah_data"><i class="mdi mdi-plus"></i></button>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <div class="text-muted pl-3 mt-1">
                                <ul class="list-group">
                                    <li class="list-item fonts-12" style="list-style: none;"><i>Tekan <span style="color:#636363; font-weight:bold;">Tombol Tambah / Enter</span> pada input nilai, untuk menyimpan pilihan obat kedalam list</i></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <br>

                    <div class="row">
                        <div class="col-lg-12">
                            <div id="data_transaksi"></div>
                        </div>
                    </div>
                    <br>

                    <div class="row">
                        <div class="col-lg-8">
                            <div class="card card-inverse-secondary mb-5">
                                <div class="card-body">
                                  <div align="center"><div style="font-family: 'Poppins'; font-weight: bold; letter-spacing: 0.5px; font-size:20px; font-style: italic;"><div id="grand_total_terbilang"></div></div></div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">

                            <table class="table3" width="100%">
                                <tbody>
                                    <tr>
                                        <td width="50%;">Harga Kamar</td>
                                        <td width="50%" align="right"><div id="harga_kamar_text"></div></td>
                                    </tr>
                                    <tr>
                                        <td>Biaya Tambahan</td>
                                        <td align="right"><div id="total_biaya_tambahan_text"></div></td>
                                    </tr>
                                    <tr style="border-bottom: 1px dashed #03a9f3;">
                                        <td style="padding-bottom: 20px;">Lama Sewa</td>
                                        <td style="padding-bottom: 20px;" align="right"><div id="lama_sewa_text"></div></td>
                                    </tr>
                                    <tr>
                                        <td style="padding-top: 20px;">Sub Total</td>
                                        <td style="padding-top: 20px;" align="right">
                                            <div id="sub_total_text"></div>
                                            <input type="hidden" id="sub_total" value="0">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="vertical-align:middle; padding-bottom: 10px;">Diskon</td>
                                        <td style="padding-bottom: 20px;" align="right">
                                            <input type="text" class="form-control form-control-sm" name="diskon" id="diskon" style="text-align:right;" value="0">
                                        </td>
                                    </tr>
                                    <tr style="border-top: 1px dashed #03a9f3;">
                                        <td style="padding-top: 20px;">Grand Total</td>
                                        <td style="padding-top: 20px;" align="right"><div id="grand_total_text"></div></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>

                    <hr>
                    <div class="row mb-2 mt-4">
                        <div class="col-lg-12">
                            <div style="float: left;">
                                <button type="submit" class="btn btn-info btn-icon-text mr-1" style="padding-top:12px;"><i class="mdi mdi-content-save" style="padding-top:4px;"></i> Simpan</button>

                                <button type="button" class="btn btn-warning btn-icon-text mr-1" style="padding-top:12px;" onclick="refresh();"><i class="mdi mdi-refresh" style="padding-top:4px;"></i> Refresh</button>

                                <a href="<?php echo $base_url; ?>/daftar/penyewa" class="btn btn-danger btn-icon-text" style="padding-top:12px;"><i class="mdi mdi-arrow-left" style="padding-top:4px;"></i> Kembali</a>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-lg-12">
                            <div id="hasil<?php echo $type; ?>">
                                <div class="spinner<?php echo $type; ?>" style="display: none;">
                                    <i class="mr-1 fonts-12">Proses Simpan ...</i><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    </form>
</div>

<script src="<?php echo $base_url; ?>/vendor/tinymce/tinymce.min.js"></script>
<script type="text/javascript">
    tinymce.init({
      selector: '#alamat',
      height: 300,
      plugins: [
        'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
        'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
        'insertdatetime', 'media', 'table', 'help', 'wordcount'
      ],
      toolbar: 'undo redo | blocks | ' +
      'bold italic backcolor | alignleft aligncenter ' +
      'alignright alignjustify | bullist numlist outdent indent | ' +
      'removeformat | help',
      content_style: 'body { font-family:Poppins; font-size:12px }'
    });


    tinymce.init({
      selector: '#kelengkapan',
      height: 300,
      plugins: [
        'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
        'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
        'insertdatetime', 'media', 'table', 'help', 'wordcount'
      ],
      toolbar: 'undo redo | blocks | ' +
      'bold italic backcolor | alignleft aligncenter ' +
      'alignright alignjustify | bullist numlist outdent indent | ' +
      'removeformat | help',
      content_style: 'body { font-family:Poppins; font-size:12px }'
    });
</script>

<script type="text/javascript">
    $(document).ready(function(e) {
        $('.select2').select2();

        $('#tgl_masuk').change(function(){
            var tgl_masuk       = $(this).val();

            var jenis_sewa      = $("#jenis_sewa").val();
            var jenis_sewa_arr  = jenis_sewa.split("~>");
            var id_jenis_sewa   = jenis_sewa_arr[0];
            var nama_jenis_sewa = jenis_sewa_arr[1];

            var lama_sewa      = $("#lama_sewa").val();
            var lama_sewa_arr       = lama_sewa.split("~>");
            var id_lama_sewa        = lama_sewa_arr[0];
            var satuan_lama_sewa    = lama_sewa_arr[1];

            if(id_jenis_sewa !='0' && id_lama_sewa !='0') {

                if (nama_jenis_sewa == "Harian") {
                    $("#tgl_selesai").val(addDays(tgl_masuk, parseInt(id_lama_sewa) ));
                    $("#tgl_selesai_2").val(addDays(tgl_masuk, parseInt(id_lama_sewa) ));
                } else {
                    $("#tgl_selesai").val(addMonths(tgl_masuk, parseInt(id_lama_sewa) ));
                    $("#tgl_selesai_2").val(addMonths(tgl_masuk, parseInt(id_lama_sewa) ));
                }

            }
        });

        $('#jenis_sewa').change(function(){
            var jenis_sewa         = $(this).val();
            var jenis_sewa         = $("#jenis_sewa").val();
            var jenis_sewa_arr     = jenis_sewa.split("~>");
            var id_sewa            = jenis_sewa_arr[0];
            var nama_jenis_sewa    = jenis_sewa_arr[1];

            var tgl_masuk = $("#tgl_masuk").val();
            if(tgl_masuk == '') {
                Swal.fire({
                  icon: "error",
                  title: "Oops...",
                  text: "Pilih Tanggal Masuk terlebih dahulu"
                });

                $('#jenis_sewa').val('0~>Pilih');
                return false;
            }

            $("#kamar").load("<?php echo $base_url; ?>/pages/penyewaan/daftar_penyewa/form.php?page=data-kamar&id_sewa="+id_sewa);

            if(jenis_sewa == '0~>Pilih') {
                $('#lama_sewa').empty();
                $('#lama_sewa').append($('<option>').text('【 Pilih 】').attr('value', '0~>Pilih'));

                $("#tgl_selesai").val('');

                $("#harga_kamar_text").text('0');
                $("#lama_sewa_text").text('-');

                var total_biaya_tambahan = $("#total_biaya_tambahan").val();
                var diskon = $("#diskon").val();
                var grand_total = total_biaya_tambahan - diskon;

                $("#sub_total_text").text( formatRibuan(total_biaya_tambahan) );
                $("#sub_total").val(total_biaya_tambahan);

                $("#grand_total_text").text( formatRibuan(grand_total) );
                $('#grand_total_terbilang').text(terbilangRupiahFormat(grand_total));

                return false;
            }

            $.ajax({
                url: "<?php echo $base_url; ?>/pages/penyewaan/daftar_penyewa/form.php?page=data-lama-sewa&id_sewa=" + id_sewa,
                type: 'GET',
                dataType: 'json',
                success: function(response) {
                    $('#lama_sewa').empty();
                    $('#lama_sewa').append($('<option>').text('【 Pilih 】').attr('value', '0~>Pilih'));
                    $.each(response, function(index, item) {
                        $('#lama_sewa').append($('<option>').text(item.lama_sewa + ' ' + item.nama_lama_sewa).attr('value', item.lama_sewa + '~>' + item.nama_lama_sewa));
                    });
                },
                error: function(xhr, status, error) {
                    console.error(error);
                }
            });
           
        });

        $('#kamar').change(function(){
            var kamar           = $(this).val();
            var kamar_arr       = kamar.split("~>");
            var id_kamar        = kamar_arr[0];
            var harga_kamar     = kamar_arr[1];

            var total_biaya_tambahan = $("#total_biaya_tambahan").val();
            var diskon = unformatRibuan( $("#diskon").val() );

            if(kamar == '0~>0') {
                $("#harga_kamar_text").text('0');
                $("#lama_sewa_text").text('-');

                $("#sub_total_text").text( formatRibuan(total_biaya_tambahan) );
                $("#sub_total").val(total_biaya_tambahan);

                var grand_total = total_biaya_tambahan - diskon;
                $("#grand_total_text").text( formatRibuan(grand_total) );
                $('#grand_total_terbilang').text(terbilangRupiahFormat(grand_total));

                return false;
            }

            var lama_sewa           = $("#lama_sewa").val();
            var lama_sewa_arr       = lama_sewa.split("~>");
            var id_lama_sewa        = lama_sewa_arr[0];
            var nama_lama_sewa      = lama_sewa_arr[1];

            if(lama_sewa == '0~>Pilih') {
                $("#harga_kamar_text").text('0');
                $("#lama_sewa_text").text('-');

                $("#sub_total_text").text( formatRibuan(total_biaya_tambahan) );
                $("#sub_total").val(total_biaya_tambahan);

                var grand_total = total_biaya_tambahan - diskon;
                $("#grand_total_text").text( formatRibuan(grand_total) );
                $('#grand_total_terbilang').text(terbilangRupiahFormat(grand_total));

                return false;
            }
            
        });

        $('#lama_sewa').change(function(){
            var lama_sewa           = $(this).val();
            var lama_sewa_arr       = lama_sewa.split("~>");
            var id_lama_sewa        = lama_sewa_arr[0];
            var nama_lama_sewa      = lama_sewa_arr[1];
            var tgl_masuk           = $("#tgl_masuk").val();

            if (nama_lama_sewa == "Hari") {
                $("#tgl_selesai").val(addDays(tgl_masuk, parseInt(id_lama_sewa) ));
                $("#tgl_selesai_2").val(addDays(tgl_masuk, parseInt(id_lama_sewa) ));
            } else {
                $("#tgl_selesai").val(addMonths(tgl_masuk, parseInt(id_lama_sewa) ));
                $("#tgl_selesai_2").val(addMonths(tgl_masuk, parseInt(id_lama_sewa) ));
            }

            var total_biaya_tambahan = $("#total_biaya_tambahan").val();
            var diskon = unformatRibuan( $("#diskon").val() );

            if(lama_sewa == '0~>Pilih') {
                $("#harga_kamar_text").text('0');
                $("#lama_sewa_text").text('-');

                $("#sub_total_text").text( formatRibuan(total_biaya_tambahan) );

                var grand_total = total_biaya_tambahan - diskon;
                $("#grand_total_text").text( formatRibuan(grand_total) );
                $('#grand_total_terbilang').text(terbilangRupiahFormat(grand_total));

                return false;
            }

            var kamar           = $("#kamar").val();
            var kamar_arr       = kamar.split("~>");
            var id_kamar        = kamar_arr[0];
            var harga_kamar     = kamar_arr[1];
            $("#harga_kamar_text").text( formatRibuan(harga_kamar) );
            $("#lama_sewa_text").text(id_lama_sewa+' '+nama_lama_sewa);

            var sub_total       = (parseInt(harga_kamar) + parseInt(total_biaya_tambahan)) * id_lama_sewa;
            $("#sub_total_text").text( formatRibuan(sub_total) );
            $("#sub_total").val(sub_total);

            var grand_total = sub_total - diskon;
            $("#grand_total_text").text( formatRibuan(grand_total) );
            $('#grand_total_terbilang').text(terbilangRupiahFormat(grand_total));
        });

         // Transaksi
        dataTransaksi();

        function dataTransaksi() {
            $.ajax({
                url: "<?php echo $base_url; ?>/pages/penyewaan/daftar_penyewa/data.php?page=daftar-transaksi&idadmin=<?php echo $idadmin; ?>",
                type: 'GET',
                dataType: 'json',
                success: function(data) {
                    var tableHtml = `
                        <div class="table-responsive">
                            <table id="myTable" class="table" style="width:100%">
                                <thead>
                                    <tr>
                                        <th width="5%">#</th>
                                        <th width="70%">Keterangan Detail</th>
                                        <th width="20%" >Nilai</th>
                                        <th width="5%">&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody>
                        `;
                    var i = 1;
                    var total = 0;
                    $.each(data, function(index, row) {
                        tableHtml += `
                                <tr>
                                    <td>`+ i +`</td>
                                    <td>`+row.keterangan_detail+`</td>
                                    <td align="right">`+ formatRibuan(row.nilai)+`</td>
                                    <td>
                                        <button type="button" class="action bg-white hapus_tmp" data-id="`+ row.id_tmp +`">
                                            <i class="mdi mdi-delete-forever"></i>
                                        </button>
                                    </td>
                                </tr>
                            `;

                            i += 1;
                            total += unformatRibuan(row.nilai);
                    });

                    tableHtml += `
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="2" align="right">Total Tambahan Biaya</td>
                                        <td align="right"><b>`+ formatRibuan(total)+`</b></td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <input type="hidden" value="`+total+`" name="total_biaya_tambahan" id="total_biaya_tambahan">
                    `;

                    $('#data_transaksi').html(tableHtml);
                    $('#myTable').DataTable({});

                    var total_biaya_tambahan = total;

                    var kamar           =$("#kamar").val();
                    var kamar_arr       = kamar.split("~>");
                    var id_kamar        = kamar_arr[0];
                    var harga_kamar     = kamar_arr[1];

                    var lama_sewa           = $("#lama_sewa").val();
                    var lama_sewa_arr       = lama_sewa.split("~>");
                    var id_lama_sewa        = lama_sewa_arr[0];
                    var nama_lama_sewa      = lama_sewa_arr[1];

                    $("#harga_kamar_text").text( formatRibuan(harga_kamar) );
                    $("#total_biaya_tambahan_text").text( formatRibuan(total_biaya_tambahan) );
                    $("#lama_sewa_text").text(id_lama_sewa+' '+nama_lama_sewa);

                    var sub_total       = (parseInt(harga_kamar) + parseInt(total_biaya_tambahan)) * id_lama_sewa;

                    $("#sub_total_text").text( formatRibuan(sub_total) );
                    $("#sub_total").val(sub_total);

                    var diskon = unformatRibuan( $("#diskon").val() );
                    var grand_total = sub_total - diskon;
                    $("#grand_total_text").text( formatRibuan(grand_total) );
                    $('#grand_total_terbilang').text(terbilangRupiahFormat(grand_total));

                },
                error: function(xhr, status, error) {
                    console.error(status, error);
                }
            });
        }

        nilai.addEventListener('input', function() {
            nilai.value          = formatRibuan(this.value);
        });

        diskon.addEventListener('input', function() {
            diskon.value  = formatRibuan(this.value);
            
            var sub_total = $("#sub_total").val();
            var diskonx = unformatRibuan(this.value);

            var grand_total = ( sub_total - diskonx ) ;
            $("#grand_total_text").text( formatRibuan(grand_total) );
            $('#grand_total_terbilang').text(terbilangRupiahFormat(grand_total));
        });

        function tambahData() {
            var keterangan_detail = $('#keterangan_detail').val();
            var nilai             = unformatRibuan($('#nilai').val());

            if(keterangan_detail == '' || nilai == '') {

                Swal.fire({
                  icon: "error",
                  title: "Oops...",
                  text: "Isi keterangan detail dan nilai dahulu!, Kemudian arahkan cursor pada nilai kemudian Enter"
                });

            } else {

                $.post("<?php echo $base_url; ?>/pages/penyewaan/daftar_penyewa/action.php?page=tambah-tmp", {
                    keterangan_detail  : keterangan_detail,
                    nilai              : nilai,
                    idadmin            : "<?php echo $idadmin; ?>"
                }).done(function(data) {
                    dataTransaksi();
                    $('#keterangan_detail').focus();

                    $('#keterangan_detail').val('');
                    $('#nilai').val('0');
                });

            }

        }

        $('#nilai').on('keydown', function(e) {
            if (e.which === 13) {
                e.preventDefault();
                tambahData();
            }
        });

        $(document).on('click', '.tambah_data', function(e) {
            tambahData();
        });

        $('#keterangan_detail').on('keydown', function(e) {
            if (e.which === 13) {
                e.preventDefault();
                Swal.fire({
                  icon: "error",
                  title: "Oops...",
                  text: "Isi keterangan detail dan nilai dahulu!, Kemudian arahkan cursor pada nilai kemudian Enter"
                });
            }
        });

        $(document).on('click','.hapus_tmp',function(e){
            $.post("<?php echo $base_url; ?>/pages/penyewaan/daftar_penyewa/action.php?page=hapus-tmp", {
                id : $(this).attr('data-id')
            }).done(function(data){
                dataTransaksi();
                $('#keterangan_detail').focus();
            });
        });

        $("#form<?php echo $type; ?>").on('submit', (function(e) {
            e.preventDefault();
            $.ajax({
                url: '<?php echo $base_url; ?>/pages/penyewaan/daftar_penyewa/proses.php',
                type: "POST",
                data: new FormData(this),
                contentType: false,
                cache: false,
                processData: false,
                beforeSend: function() {
                    $(".spinner<?php echo $type; ?>").css("display", "block");
                    $("#hasil<?php echo $type; ?>").show();
                },
                success: function(data) {
                    $("#hasil<?php echo $type; ?>").html(data);
                    $(".spinner<?php echo $type; ?>").css("display", "none");

                    setTimeout(function() {
                        $("#hasil<?php echo $type; ?>").hide(data);
                    }, 1500);
                },
                error: function() {}
            })
        }));
    });
</script>


<script type="text/javascript">
    function addMonths(date, months) {
        const dateTime = new Date(date);
        const originalDay = dateTime.getDate();

        dateTime.setMonth(dateTime.getMonth() + months);

        if (dateTime.getDate() < originalDay) {
            dateTime.setDate(0);
        }

        return dateTime.toISOString().split('T')[0];
    }

    function addDays(date, days) {
        const dateTime = new Date(date);
        dateTime.setDate(dateTime.getDate() + days);
        return dateTime.toISOString().split('T')[0];
    }
</script>