<?php 
// Load PHPMailer library
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

include ('../../../include/koneksi.php'); 
require '../../../vendor/autoload.php'; // Sesuaikan path dengan pengaturan Anda jika menggunakan Composer

// Ambil nilai dari form
$id_sewa_detail = pengaman($_POST['id_sewa_detail']);
$email_tujuan = pengaman($_POST['email_tujuan']);

// Query untuk mengambil data dari database
$sql = mysqli_query($conn, "
    SELECT
        a.*, b.*, c.*, d.no_kamar
    FROM 
        master_sewa_detail a
    INNER JOIN 
        master_sewa b ON a.id_sewa = b.id_sewa
    LEFT JOIN
        master_penghuni c ON b.id_penghuni = c.id_penghuni
    LEFT JOIN 
        master_kamar d ON b.id_kamar = d.id_kamar
    WHERE 
        a.id_sewa_detail = '$id_sewa_detail'
");
$row = mysqli_fetch_array($sql);

$nama_penghuni = $row['nama_penghuni'];
$nama_jenis_sewa = $row['nama_jenis_sewa'];
$no_kamar = $row['no_kamar'];
$grand_total = 'Rp. ' . number_format($row['grand_total']);
$tgl_selesai = $row['tgl_selesai'];
$alamat = $row['alamat'];
$alamat = str_replace("<br />", "\n", $alamat);
$alamat = strip_tags($alamat);

// Template email dengan data yang diambil
$informasi_tambahan = "
<!DOCTYPE html>
<html lang='en'>
<head>
    <meta charset='UTF-8'>
    <meta http-equiv='X-UA-Compatible' content='IE=edge'>
    <meta name='viewport' content='width=device-width, initial-scale=1.0'>
    <title>Notification Email</title>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            line-height: 1.5em;
            color: #333;
            font-size: 13px;
        }
        .container {
            width: 100%;
            max-width: 600px;
            margin: 0 auto;
            border: 1px solid #e0e0e0;
            border-radius: 8px;
            background-color: #f9f9f9;
        }
        .header {
            text-align: center;
            margin-bottom: 15px;
            background: #03a9f3;
            padding: 20px;
        }
        .content {
            margin-bottom: 20px;
            padding: 20px;
        }
        .footer {
            text-align: center;
            font-size: 12px;
            color: #fff;
            background: #03a9f3;
            padding: 10px 10px;
        }
        .footer h2 { padding: 0; margin: 0; margin-bottom: 10px; }
        ul {
            list-style-type: none;
            padding-left: 0;
        }
        ul li {
            margin-bottom: 10px;
        }
        .table2 {
            font-size: 13px;
            border-collapse: collapse;
            text-align: justify;
            line-height: 1.9em;
            margin-bottom: 10px;
            font-family: 'Poppins', sans-serif;
        }
        .table2 thead th {
            padding: 8px 10px;
            border-bottom: 1px solid #ccc;
            vertical-align: middle;
            font-weight: normal;
        }
        .table2 tbody td {
            padding: 8px 10px;
            color: #000;
            border: none;
            vertical-align: middle;
        }
    </style>
</head>
<body>
    <div class='container'>
        <div class='header'>
            <img src='{$base_url}/assets/img/{$logo_home}' style='width:100%;' alt='{ $nama_perusahaan }'>
        </div>
        <div class='content'>
            <p><b>Halo</b> Evans Noeryga,</p>
            <p>Terima kasih atas kepercayaan Anda untuk memilih kost di tempat kami.</p>
            <p>Berikut kami informasikan bahwa masa sewa kost Anda sudah/telah berakhir. Segera lakukan pembayaran untuk dapat melanjutkan tinggal di Kost kami.</p>
            <p><b>Detail Informasi:</b></p>
            <table class='table2'>
                <thead>
                    <tr>
                        <th>Nama Penghuni</th>
                        <th>:</th>
                        <th>{$nama_penghuni}</th>
                    </tr>
                    <tr>
                        <th>Alamat</th>
                        <th>:</th>
                        <th>{$alamat}</th>
                    </tr>
                    <tr>
                        <th>Jenis Sewa</th>
                        <th>:</th>
                        <th>{$nama_jenis_sewa}</th>
                    </tr>
                    <tr>
                        <th>Kamar</th>
                        <th>:</th>
                        <th>{$no_kamar}</th>
                    </tr>
                    <tr>
                        <th>Nominal Pembayaran</th>
                        <th>:</th>
                        <th>{$grand_total}</th>
                    </tr>
                    <tr>
                        <th>Jatuh Tempo</th>
                        <th>:</th>
                        <th>{$tgl_selesai}</th>
                    </tr>
                </thead>
            </table>

            <p>Berikut adalah pilihan rekening bank untuk pembayaran transfer.</p>
            <p>".nl2br($no_rekening_perusahaan)."</p>
            <p>Mohon konfirmasi ulang jika sudah melakukan pembayaran dan bukti transfernya dikirimkan ke nomor ini! Terima kasih.</p>
        </div>
        <div class='footer'>
            <h2>{$nama_perusahaan}</h2>
            <p>{$alamat_perusahaan}<br>
               {$email_perusahaan}<br>
               {$no_tlp_perusahaan}</p>
        </div>
    </div>
</body>
</html>
";

// Konfigurasi SMTP
$mail = new PHPMailer(true);
$mail->isSMTP();
$mail->Host = $smtp_host; // Ganti dengan hostname SMTP Anda
$mail->SMTPAuth = true;
$mail->Username = $smtp_username; // Ganti dengan email Anda
$mail->Password = $smtp_password; // Ganti dengan password email Anda
$mail->SMTPSecure = $smtp_secure; // TLS atau SSL, sesuaikan dengan pengaturan provider email Anda
$mail->Port = $smtp_port; // Port SMTP, sesuaikan dengan pengaturan provider email Anda

// Set pengirim dan penerima email
$mail->setFrom($email_perusahaan, $nama_perusahaan); // Ganti dengan email dan nama Anda
$mail->addAddress($email_tujuan); // Email tujuan

// Set subjek dan isi email
$mail->isHTML(true); // Set email sebagai HTML
$mail->Subject = 'Informasi Tagihan Kost';
$mail->Body = $informasi_tambahan; // Isi pesan, bisa berupa teks atau HTML

// Coba kirim email
try {
    $mail->send();
    echo "
        <div class='alert alert-success alert-dismissible fade show fonts-12' role='alert'>
            <i class='mdi mdi-check-circle-outline mr-1'></i> <b>Email berhasil terkirim</b>
        </div>
    ";
} catch (Exception $e) {
    echo "
        <div class='alert alert-danger alert-dismissible fade show fonts-12' role='alert'>
            <i class='mdi mdi-close-circle-outline mr-1'></i> <b>Email gagal terkirim,</b> Terjadi kesalahan {$mail->ErrorInfo}.
        </div>
    ";
}
?>
