<?php
$page_menu = "Pengaturan";
$foundValues = array();
foreach ($array_role_akses as $value) {
    if (strpos($value, $page_menu) !== false) {
        $foundValues[] = $value;
    }
}
$hak_akses_menu = implode(', ', $foundValues);
if($hak_akses_menu == "$page_menu-None") {
    echo "<script>location.replace(' $base_url/halaman/tidak/ditemukan') </script>";
}

$link_hak_akses_menu = str_replace(" ","_",  $hak_akses_menu);
$arr       = explode("-", $link_hak_akses_menu);
$hak_akses = $arr[1];
?>

<div class="content-wrapper">
    <div class="page-titles">
        <ol class="breadcrumb breadcrumb-custom">
            <li class="breadcrumb-item"><a href="<?php echo $base_url; ?>/dashboard">Dashbboard</a></li>
            <?php
            for ($i = 0; $i < count($parts); $i++) {
                if ($i == count($parts) - 1) {
                    // Jika ini adalah kata terakhir, tambahkan kelas "active"
                    echo '<li class="breadcrumb-item active" aria-current="page">' . ucfirst($parts[$i]) . '</li>';
                } else {
                    // Jika bukan kata terakhir, tambahkan tautan
                    echo '<li class="breadcrumb-item"><a href="#">' . ucfirst($parts[$i]) . '</a></li>';
                }
            }
            ?>
        </ol>
    </div>

    <?php $type = 'rubah'; ?>
    <form id="form<?php echo $type; ?>" method="post" autocomplete="off">
    <input type="hidden" name='idadmin' value="<?php echo $idadmin; ?>" />
    <input type="hidden" name='type' value="<?php echo $type; ?>">
    
    <div class="row">
        <div class="col-md-12 grid-margin stretch-card">
            <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-md-12">
                            <h4 class="card-title"><i class="mdi mdi-lead-pencil mr-1"></i> Form</h4>  
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h4 class="card-title">Informasi Perusahaan</h4>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Nama <code>*</code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="nama_perusahaan" value="<?php echo $nama_perusahaan; ?>" required="">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Aplikasi <code>*</code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="nama_aplikasi" value="<?php echo $nama_aplikasi; ?>" required="">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Telepon <code></code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="no_tlp" value="<?php echo $no_tlp_perusahaan; ?>">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Email <code></code></label>
                                        <div class="col-sm-9">
                                            <input type="email" class="form-control form-control-sm" name="email" value="<?php echo $email_perusahaan; ?>">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Alamat <code></code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="alamat" value="<?php echo $alamat_perusahaan; ?>">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Provinsi <code></code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="nama_provinsi" value="<?php echo $nama_provinsi_perusahaan; ?>">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Kota <code></code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="nama_kota" value="<?php echo $nama_kota_perusahaan; ?>">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Kecamatan <code></code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="nama_kecamatan" value="<?php echo $nama_kecamatan_perusahaan; ?>">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">No Rekening <code></code></label>
                                        <div class="col-sm-9">
                                            <textarea class="form-control form-control-sm" name="no_rekening" rows="10"><?php echo $no_rekening_perusahaan; ?></textarea>
                                        </div>
                                    </div>

                                    <h4 class="card-title">SMTP</h4>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Host <code></code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="smtp_host" value="<?php echo $smtp_host; ?>">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Username <code></code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="smtp_username" value="<?php echo $smtp_username; ?>">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Password <code></code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="smtp_password" value="<?php echo $smtp_password; ?>">
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Secure <code></code></label>
                                        <div class="col-sm-9">
                                            <select class="form-control form-control-sm form-select select2" name="smtp_secure" id="smtp_secure" style="width: 100%;" required="">
                                                <option value="tls" <?php if($smtp_secure == 'tls') echo 'selected'; ?> >TLS</option>
                                                <option value="ssl" <?php if($smtp_secure == 'ssl') echo 'selected'; ?> >SSL</option>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Port <code></code></label>
                                        <div class="col-sm-9">
                                            <input type="text" class="form-control form-control-sm" name="smtp_port" value="<?php echo $smtp_port; ?>">
                                        </div>
                                    </div>


                                    <hr style="border: 1px dashed #03a9f3;">
                                    <div class="row mb-2 mt-4">
                                        <div class="col-lg-12">
                                            <div style="">
                                                <?php if($hak_akses == 'Hapus') { ?>
                                                <button type="submit" class="btn btn-info btn-icon-text mr-1" style="padding-top:12px;"><i class="mdi mdi-content-save" style="padding-top:4px;"></i> Simpan</button>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mt-3">
                                        <div class="col-lg-12">
                                            <div id="hasil<?php echo $type; ?>">
                                                <div class="spinner<?php echo $type; ?>" style="display: none;">
                                                    <i class="mr-1 fonts-12">Proses Simpan ...</i><span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div class="row">
                                <div class="col-lg-12">
                                    <h4 class="card-title">Informasi Gambar</h4>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Favicon <code>*</code></label>
                                        <div class="col-sm-9">
                                            <input type="file" class="form-control form-control-sm" name="file_favicon">
                                            <input type="hidden" name="file_favicon_lama" value="<?php echo $favicon; ?>"> 
                                            <span class="form-text text-muted mb-2 fonts-12" style="line-height:1.5em;"><i>*) Maksimal Size 200 Kb. Ukuran Gambar 32 px X 32 px</i></span>
                                            <br>
                                            <img src="<?php echo $base_url; ?>/assets/img/<?php echo $favicon; ?>">
                                        </div>
                                    </div>
                                    <br>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Background Login <code>*</code></label>
                                        <div class="col-sm-9">
                                            <input type="file" class="form-control form-control-sm" name="file_bg_login">
                                            <input type="hidden" name="file_bg_login_lama" value="<?php echo $bg_login; ?>"> 
                                            <span class="form-text text-muted mb-2 fonts-12" style="line-height:1.5em;"><i>*) Maksimal Size 200 Kb</i></span>
                                            <br>
                                            <img src="<?php echo $base_url; ?>/assets/img/<?php echo $bg_login; ?>" width="200">
                                        </div>
                                    </div>
                                    <br>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Logo Login <code>*</code></label>
                                        <div class="col-sm-9">
                                            <input type="file" class="form-control form-control-sm" name="file_logo_login">
                                            <input type="hidden" name="file_logo_login_lama" value="<?php echo $logo_login; ?>"> 
                                            <span class="form-text text-muted mb-2 fonts-12" style="line-height:1.5em;"><i>*) Maksimal Size 200 Kb. Ukuran Gambar 350 px X 60 px</i></span>
                                            <br>
                                            <img src="<?php echo $base_url; ?>/assets/img/<?php echo $logo_login; ?>" width="200">
                                        </div>
                                    </div>
                                    <br>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Logo Home <code>*</code></label>
                                        <div class="col-sm-9">
                                            <input type="file" class="form-control form-control-sm" name="file_logo_home">
                                            <input type="hidden" name="file_logo_home_lama" value="<?php echo $logo_home; ?>"> 
                                            <span class="form-text text-muted mb-2 fonts-12" style="line-height:1.5em;"><i>*) Maksimal Size 200 Kb. Ukuran Gambar 350 px X 60 px</i></span>
                                            <br>
                                            <div style="background:#e6e6e6; padding: 10px;">
                                                <img src="<?php echo $base_url; ?>/assets/img/<?php echo $logo_home; ?>" width="200">
                                            </div>
                                        </div>
                                    </div>
                                    <br>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">Small Logo Home <code>*</code></label>
                                        <div class="col-sm-9">
                                            <input type="file" class="form-control form-control-sm" name="file_small_logo">
                                            <input type="hidden" name="file_small_logo_lama" value="<?php echo $small_logo; ?>"> 
                                            <span class="form-text text-muted mb-2 fonts-12" style="line-height:1.5em;"><i>*) Maksimal Size 200 Kb. Ukuran Gambar 120 px X 120 px</i></span>
                                            <br>
                                            <div style="background:#e6e6e6; padding: 10px;">
                                                <img src="<?php echo $base_url; ?>/assets/img/<?php echo $small_logo; ?>" width="50">
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>                    
                </div>
            </div>
        </div>
    </div>
    
    </form>
</div>

<script type="text/javascript">
$(document).ready(function() {
    $("#form<?php echo $type; ?>").on('submit', (function(e) {
        e.preventDefault();
        $.ajax({
            url: '<?php echo $base_url; ?>/pages/pengaturan/proses.php',
            type: "POST",
            data: new FormData(this),
            contentType: false,
            cache: false,
            processData: false,
            beforeSend: function() {
                $(".spinner<?php echo $type; ?>").css("display", "block");
                $("#hasil<?php echo $type; ?>").show();
            },
            success: function(data) {
                $("#hasil<?php echo $type; ?>").html(data);
                $(".spinner<?php echo $type; ?>").css("display", "none");

                setTimeout(function() {
                    location.reload();
                }, 1500);
            },
            error: function() {}
        })
    }));
});
</script>

